/*
 * Decompiled with CFR 0.152.
 */
package org.opentsdb.client;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opentsdb.client.response.SimpleHttpResponse;

public class PoolingHttpClient {
    private static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 200;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 200;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 10000;
    private static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 10000;
    private static final int DEFAULT_WAIT_TIMEOUT_MILLISECONDS = 10000;
    private static final int DEFAULT_KEEP_ALIVE_MILLISECONDS = 300000;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final int DEFAULT_RETRY_COUNT = 2;
    private int keepAlive = 300000;
    private int maxTotalConnections = 200;
    private int maxConnectionsPerRoute = 200;
    private int connectTimeout = 10000;
    private int readTimeout = 10000;
    private int waitTimeout = 10000;
    private int retries = 2;
    private PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
    private CloseableHttpClient httpClient = null;
    private ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(){

        @Override
        public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                return Long.parseLong(value) * 1000L;
            }
            return PoolingHttpClient.this.keepAlive;
        }
    };

    public PoolingHttpClient() {
        this.connManager.setMaxTotal(this.maxTotalConnections);
        this.connManager.setDefaultMaxPerRoute(this.maxConnectionsPerRoute);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.waitTimeout).setSocketTimeout(this.readTimeout).build();
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (proxyHost != null && proxyPort != null) {
            System.out.println("Using proxy: " + proxyHost + ":" + Integer.parseInt(proxyPort));
            HttpHost proxy = new HttpHost(proxyHost, Integer.parseInt(proxyPort), "http");
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            this.httpClient = HttpClients.custom().setKeepAliveStrategy(this.keepAliveStrategy).setConnectionManager(this.connManager).setDefaultRequestConfig(config).setRoutePlanner(routePlanner).build();
        } else {
            this.httpClient = HttpClients.custom().setKeepAliveStrategy(this.keepAliveStrategy).setConnectionManager(this.connManager).setDefaultRequestConfig(config).build();
        }
        IdleConnectionMonitorThread staleMonitor = new IdleConnectionMonitorThread(this.connManager);
        staleMonitor.start();
    }

    public SimpleHttpResponse doPost(String url, String data) throws IOException {
        StringEntity requestEntity = new StringEntity(data);
        HttpPost postMethod = new HttpPost(url);
        postMethod.setEntity(requestEntity);
        HttpResponse response = this.execute(postMethod);
        int statusCode = response.getStatusLine().getStatusCode();
        SimpleHttpResponse simpleResponse = new SimpleHttpResponse();
        simpleResponse.setStatusCode(statusCode);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String ctype = entity.getContentType().getValue();
            String charset = PoolingHttpClient.getResponseCharset(ctype);
            String content = EntityUtils.toString(entity, charset);
            simpleResponse.setContent(content);
        }
        return simpleResponse;
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        CloseableHttpResponse response;
        int tries = ++this.retries;
        while (true) {
            --tries;
            try {
                response = this.httpClient.execute(request);
            }
            catch (IOException e) {
                if (tries >= 1) continue;
                throw e;
            }
            break;
        }
        return response;
    }

    public void shutdown() throws IOException {
        this.httpClient.close();
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public void setMaxTotalConnections(int maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public void setMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getWaitTimeout() {
        return this.waitTimeout;
    }

    public void setWaitTimeout(int waitTimeout) {
        this.waitTimeout = waitTimeout;
    }

    public PoolingHttpClientConnectionManager getConnManager() {
        return this.connManager;
    }

    public void setConnManager(PoolingHttpClientConnectionManager connManager) {
        this.connManager = connManager;
    }

    public int getRetryCount() {
        return this.retries;
    }

    public void setRetryCount(int retries) {
        Preconditions.checkArgument(retries >= 0);
        this.retries = retries;
    }

    public static class IdleConnectionMonitorThread
    extends Thread {
        private final HttpClientConnectionManager connMgr;
        private volatile boolean shutdown;

        public IdleConnectionMonitorThread(HttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitorThread idleConnectionMonitorThread = this;
                    synchronized (idleConnectionMonitorThread) {
                        this.wait(5000L);
                        this.connMgr.closeExpiredConnections();
                        this.connMgr.closeIdleConnections(60L, TimeUnit.SECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException ex) {
                this.shutdown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitorThread idleConnectionMonitorThread = this;
            synchronized (idleConnectionMonitorThread) {
                this.notifyAll();
            }
        }
    }
}

