# Remote Attestation in Science DMZ with Xilinx-U280

This repository contains the code and configuration files for a remote attestation experiment in a Science DMZ environment.  It includes Ansible playbooks for deployment, P4 and SystemVerilog code for the SmartNIC, and supporting documentation.

## Directory Structure
```
.
├── ansible                  # Ansible playbooks for deployment and configuration
│   ├── all.yaml             # Main playbook for overall setup
│   ├── connect-x6-tasks     # Playbooks for ConnectX-6 card configuration (DPDK, Pktgen)
│   │   ├── ...              # Various tasks for VFIO, GRUB, Mellanox drivers, NFS, Pktgen
│   └── fpga-tasks           # Playbooks for FPGA (U280) related tasks
│       ├── ...              # Tasks for building, installing, and configuring the FPGA
├── imgs       
│    ├── ...                 # Images used in the documentation (diagrams, etc.)
├── p4_with_extern           # P4 and SystemVerilog code for the U280 SmartNIC
│   ├── p4_with_extern.p4    # P4 program
│   └── smartnic_extern.sv   # SystemVerilog code
└── radmz.ipynb              # Jupyter Notebook for running this experiment
```

## Generating bitstream (Optional)
The P4 and SystemVerilog code resides in the p4_with_extern directory. To generate your own bitstream, follow these steps, referencing the instructions at [https://github.com/esnet/esnet-smartnic-hw](https://github.com/esnet/esnet-smartnic-hw) and using Vivado 2023.1.

1. Clone the Repository:
```Bash
git clone https://github.com/esnet/esnet-smartnic-hw
```

2. Checkout Specific Commit:
```Bash
cd esnet-smartnic-hw
git checkout d3782445ce5f090ca955693a98ce68f96b68943c
git submodule update --init --recursive
```

3. Copy Source Files: Copy the P4 and SystemVerilog files from the radmz/p4_with_extern directory to the cloned repository:

```Bash
cp ../radmz/p4_with_extern/p4_with_extern.p4 ./examples/p4_with_extern/p4/p4_with_extern.p4
cp ../radmz/p4_with_extern/smartnic_extern.sv ./examples/p4_with_extern/extern/rtl/smartnic_extern.sv
```

4. Build the Bitstream:

```Bash
cd examples/p4_with_extern
make
```

5. Upload the generated bitstream to your own repository.
6. Update Ansible Configuration
- In `ansible/fpga-tasks/main-docker-pull.yaml`, change the `ra_artifacts_repo` variable to point to your repository where you uploaded the bitstream.

---
## Author
Hyunsuk Bang [hbang3@hawk.iit.edu](hbang3@hawk.iit.edu)

## Acknowledgments
Nik Sultana [nsultana1@iit.edu](nsultana1@iit.edu)\
Nishanth Shyamkumar [nshyamkumar@iit.edu](nshyamkumar@iit.edu)\
Chirstopher E. Neely 
