#!/bin/bash

cwd=`pwd`

path=$(dirname "$0")

cd $path

NIC_LOCAL=$1
IP_LOCAL=$2
SUBNET_ALL=$3

HOSTNAME=$(hostname)


{

echo NIC_LOCAL $NIC_LOCAL
echo IP_LOCAL $IP_LOCAL
echo SUBNET_ALL $SUBNET_ALL

HOSTNAME=$(hostname)

#sudo dnf install -y vim tcpdump frr
sudo sysctl -w net.ipv4.ip_forward=1


#cp -a /etc/frr .
#sudo chown -R rocky:rocky frr
mkdir -p frr
sudo chown -R rocky:rocky frr

#sudo sed -i 's/ospfd=no/ospfd=yes/g' frr/daemons

cat > frr/daemons <<EOL
# This file tells the frr package which daemons to start.
#
# Sample configurations for these daemons can be found in
# /usr/share/doc/frr/examples/.
#
# ATTENTION:
#
# When activating a daemon for the first time, a config file, even if it is
# empty, has to be present *and* be owned by the user and group "frr", else
# the daemon will not be started by /etc/init.d/frr. The permissions should
# be u=rw,g=r,o=.
# When using "vtysh" such a config file is also needed. It should be owned by
# group "frrvty" and set to ug=rw,o= though. Check /etc/pam.d/frr, too.
#
# The watchfrr, zebra and staticd daemons are always started.
#
bgpd=no
ospfd=yes
ospf6d=no
ripd=no
ripngd=no
isisd=no
pimd=no
nhrpd=no
eigrpd=no
sharpd=no
pbrd=no
bfdd=no
fabricd=no
vrrpd=no

#
# If this option is set the /etc/init.d/frr script automatically loads
# the config via "vtysh -b" when the servers are started.
# Check /etc/pam.d/frr if you intend to use "vtysh"!
#
vtysh_enable=yes
zebra_options="  -A 127.0.0.1 -s 90000000"
bgpd_options="   -A 127.0.0.1"
ospfd_options="  -A 127.0.0.1"
ospf6d_options=" -A ::1"
ripd_options="   -A 127.0.0.1"
ripngd_options=" -A ::1"
isisd_options="  -A 127.0.0.1"
pimd_options="   -A 127.0.0.1"
nhrpd_options="  -A 127.0.0.1"
eigrpd_options=" -A 127.0.0.1"
sharpd_options=" -A 127.0.0.1"
pbrd_options="   -A 127.0.0.1"
staticd_options="-A 127.0.0.1"
bfdd_options="   -A 127.0.0.1"
fabricd_options="-A 127.0.0.1"
vrrpd_options="  -A 127.0.0.1"

# configuration profile
#
#frr_profile="traditional"
#frr_profile="datacenter"

#
# This is the maximum number of FD's that will be available.
# Upon startup this is read by the control files and ulimit
# is called.  Uncomment and use a reasonable value for your
# setup if you are expecting a large number of peers in
# say BGP.
#MAX_FDS=1024

# The list of daemons to watch is automatically generated by the init script.
#watchfrr_options=""

# To make watchfrr create/join the specified netns, use the following option:
#watchfrr_options="--netns"
# This only has an effect in /etc/frr/<somename>/daemons, and you need to
# start FRR with "/usr/lib/frr/frrinit.sh start <somename>".

# for debugging purposes, you can specify a "wrap" command to start instead
# of starting the daemon directly, e.g. to use valgrind on ospfd:
#   ospfd_wrap="/usr/bin/valgrind"
# or you can use "all_wrap" for all daemons, e.g. to use perf record:
#   all_wrap="/usr/bin/perf record --call-graph -"
# the normal daemon command is added to this at the end.
EOL




#Edit /etc/frr/zebra: add these lines
cat > frr/zebra.conf <<EOL
hostname $HOSTNAME 
log file /var/log/zebra.log
!
interface ${NIC_LOCAL}
 ip address ${IP_LOCAL}/24
EOL



cat > frr/ospfd.conf  <<EOL
hostname $HOSTNAME
log file /var/log/ospfd.log
!
interface ${NIC_LOCAL}
 ip ospf hello-interval 60
 ip ospf dead-interval 240
!
!
router ospf
 ospf router-id ${IP_LOCAL}
 log-adjacency-changes
 redistribute kernel
 redistribute connected
 redistribute static
 network ${SUBNET_ALL}/16 area 1
 access-list 20 permit ${SUBNET_ALL} 0.0.255.255
 access-list 20 deny any
!
line vty
EOL

#sudo systemctl daemon-reload
#sudo systemctl start frr.service
#/usr/libexec/frr/frrinit.sh start

} 2>&1 > frr_config.log  

cd $cwd