from typing import Sequence

from config.config_option import ConfigOption
from config.configuration_manager import current_configuration_manager


def sorted_by_parenthood(options: Sequence[ConfigOption]) -> Sequence[ConfigOption]:
    parent_options = [o for o in options if is_parent_option(o.p4studio_name)]
    parent_option_names = [o.p4studio_name for o in parent_options]
    rest = [o for o in options if o.p4studio_name not in parent_option_names]
    return parent_options + rest


def is_parent_option(option: str) -> bool:
    return current_configuration_manager().definition(option).category.lower() == option
