#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from os.path import join, exists
from pathlib import Path

from dependencies.source.source_dependency_config import SourceDependencyConfig
from utils.processes import execute


def download_libcli(config: SourceDependencyConfig) -> None:
    version = config.dependency_manager().source_dependency_attributes("libcli")['version']
    repo_dir = config.download_dir(ensure_exists=False)
    if not repo_dir.exists():
        execute("git clone https://github.com/dparrish/libcli {}".format(repo_dir))
        execute("git -c advice.detachedHead=false checkout V{}".format(version), repo_dir)


def install_libcli(config: SourceDependencyConfig) -> None:
    version = config.dependency_manager().source_dependency_attributes("libcli")['version']

    if not config.force and _is_libcli_installed(config.install_dir, version):
        return

    download_libcli(config)
    build_dir = config.build_dir(copy_download_dir=True)
    execute("make -j{}".format(config.jobs), build_dir)
    execute('make PREFIX={} install -j{}'.format(config.install_dir, config.jobs), build_dir)
    execute("sudo ldconfig")


def _is_libcli_installed(path: Path, version: str) -> bool:
    return (path / "lib/libcli.so.{}".format(version)).exists()
