#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
from pathlib import Path

from dependencies.dependency_manager import dependency_manager, DependencyManager
from utils.processes import execute


class SourceDependencyConfig:
    def __init__(
            self,
            os_name: str,
            os_version: str,
            build_dir: Path,
            download_dir: Path,
            install_dir: Path,
            jobs: int,
            with_proto: str,
            force: bool
    ):
        self.os_name = os_name
        self.os_version = os_version
        self._download_dir = download_dir
        self._build_dir = build_dir
        self.install_dir = install_dir
        self.jobs = jobs
        self.with_proto = with_proto
        self.force = force

    def download_dir(self, ensure_exists: bool) -> Path:
        if ensure_exists and not self._build_dir.exists():
            execute("mkdir -p {}".format(self._download_dir))
        return self._download_dir

    def build_dir(self, copy_download_dir: bool = False) -> Path:
        if not self._build_dir.exists():
            execute("mkdir -p {}".format(self._build_dir))

        if copy_download_dir:
            execute("cp -a {}/. {}".format(self._download_dir / '.', self._build_dir))

        return self._build_dir

    def dependency_manager(self) -> DependencyManager:
        return dependency_manager(self.os_name, self.os_version)

    @property
    def os(self) -> str:
        return "{}:{}".format(self.os_name, self.os_version)
