#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from dependencies.source.install_boost import install_boost
from dependencies.source.install_bridge_utils import install_bridge_utils
from dependencies.source.install_grpc import install_grpc
from dependencies.source.install_libcli import install_libcli
from dependencies.source.install_pi import install_pi
from dependencies.source.install_thrift import install_thrift
from dependencies.source.source_dependency_config import SourceDependencyConfig
from utils.exceptions import ApplicationException
from utils.terminal import compact_log

_DEP_TO_FUNC = {
    "libcli": install_libcli,
    "pi": install_pi,
    "boost": install_boost,
    "grpc": install_grpc,
    "thrift": install_thrift,
    "bridge": install_bridge_utils
}


def install_source_dependency(name: str, config: SourceDependencyConfig) -> None:
    global _DEP_TO_FUNC
    func = _DEP_TO_FUNC.get(name)
    if not func:
        raise ApplicationException("Unknown dependency: {}".format(name))

    compact_log().start_new("  - {}: ".format(name))
    try:
        func(config)
        compact_log().done(True)
    except Exception as e:
        compact_log().done(False)
        raise e
