#!/usr/bin/env python3
from pathlib import Path
#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
from typing import List

from workspace import current_workspace


class P4ProgramInfo:
    def __init__(self, name: str, group: str, path: Path):
        self.name = name
        self.group = group
        self.path = path


def all_p4_programs() -> List[P4ProgramInfo]:
    result = []
    for group_name, group_path in current_workspace().p4_dirs.items():
        if not group_path.exists():
            continue
        for path in group_path.iterdir():
            if path.is_dir() and path.name not in ['common']:
                program = P4ProgramInfo(path.name, group_name, path)
                result.append(program)
    result.sort(key=lambda p: (p.group, p.name))
    return result
