#!/usr/bin/env python3


#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from typing import List

from utils.terminal import print_normal, print_green


class CheckResult:
    def __init__(self, name: str, value: str, ok: bool):
        self.ok = ok
        self.name = name
        self.value = value

    def __str__(self) -> str:
        return " {} {}: {}".format('✓' if self.ok else '✗', self.name, self.value)


def print_multiple_checks(check_results: List[CheckResult]) -> None:
    print_green("Checking system capabilities to build and install SDE:")
    for check_result in check_results:
        print_normal(str(check_result))
