#!/usr/bin/env python3

#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from collections import OrderedDict
from typing import Any, Callable, Union, Optional, List, Mapping

import click
from click import Option, Context, Command
from utils.click_cmds import get_full_cmd_str
from utils.processes import cmd_args_to_str


class OrderedGroup(click.Group):
    def __init__(self, name: Optional[str] = None,
                 commands: Mapping[str, Command] = None, **attrs: Any) -> None:
        super().__init__(name, commands, **attrs)
        self.commands = commands or OrderedDict()

    def list_commands(self, ctx: Context) -> List[str]:
        return list(self.commands.keys())


class BetterOption(Option):
    def get_default(self, ctx: Context) -> Optional[Union[object, Callable[[], object]]]:
        if ctx.default_map and self.name in ctx.default_map:
            return ctx.default_map[self.name]
        else:
            return super().get_default(ctx)


def command_call_to_str(command: Command, **kwargs: Any) -> str:
    import main
    _, result = get_full_cmd_str(command, main.p4studio_cli.commands, ['p4studio'])

    params = {
        param.name: param
        for param in command.params
    }

    for arg, value in kwargs.items():
        if value in (None, ()):
            continue
        param = params[arg]
        if isinstance(param, Option):
            result += [param.opts[0]]

        result += list(value) if isinstance(value, tuple) else [value]

    return cmd_args_to_str(result)
