#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
import shutil
import tempfile
from urllib import request

from utils.exceptions import ApplicationException
from utils.terminal import compact_log


def download(url: str) -> str:
    file_name = tempfile.mkdtemp() + '/' + url.split("/")[-1]
    try:
        compact_log().log("downloading: {}".format(url))
        with request.urlopen(url) as response, open(file_name, 'wb') as out_file:
            shutil.copyfileobj(response, out_file)
    except Exception as e:
        compact_log().log(str(e))
        raise ApplicationException from e
    return file_name
