#!/usr/bin/env python3
from typing import Any

#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2021 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from utils.exceptions import ApplicationException


def user_provided_format(formatter: str, **kwargs: Any) -> str:
    try:
        return formatter.format(**kwargs)
    except KeyError as e:
        available_keys = ', '.join(kwargs.keys())
        message = "Incorrect key. {} does not match any of: {}.".format(e, available_keys)
        raise ApplicationException(message)
    except Exception as e:
        raise ApplicationException(e)
