#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

import subprocess

from utils.processes import execute
from utils.types import PathLike


def git_clone(repo: str, branch: str, path: PathLike, recursive: bool = True) -> None:
    command = ["git", "clone", "--depth 1"]
    if recursive:
        command += ["--shallow-submodules", "--recursive", "--jobs 21"]

    command += [repo, "'{}'".format(path), "-b '{}'".format(branch)]
    command_str = " ".join(command)
    execute(command_str)


def git_update_submodules(path: PathLike) -> None:
    command = ['git', '-C', "'{}'".format(path), 'submodule', 'update', '--init', '--recursive']
    advanced_options_available = '--depth' in subprocess.getoutput("git -C '{}' submodule update -h".format(path))
    if advanced_options_available:
        command += ['--jobs 21', '--depth 1']

    command_str = " ".join(command)
    execute(command_str)
