#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.

from typing import TypeVar, List, cast, Dict

T = TypeVar('T')


def reverse_topological_sort(graph: Dict[T, List[T]]) -> List[T]:
    result = cast(List[T], [])
    stack = cast(List[T], list(graph.keys())[::-1])

    while stack:
        current = stack.pop()
        if current in result:
            continue
        not_in_result = [node for node in graph.get(current, []) if node not in result]
        if not_in_result:
            stack.append(current)
            stack.extend(not_in_result[::-1])
        else:
            result.append(current)

    return result
