#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
from collections import OrderedDict
from typing import TypeVar, Set, Iterable, Iterator

T = TypeVar('T')


class OrderedSet(Set[T], Iterable[T]):

    def __init__(self, *args: T):
        self._internal = OrderedDict()  # type: ignore
        for arg in args:
            self.add(arg)

    def add(self, element: T) -> None:
        self._internal[element] = None

    def __iter__(self) -> Iterator[T]:
        return self._internal.keys().__iter__()

    def __eq__(self, other: object) -> bool:
        return self._internal_set() == other

    def _internal_set(self) -> Set[T]:
        return set(self._internal.keys())

    def __bool__(self) -> bool:
        return bool(self._internal_set())

    def __contains__(self, item: object) -> bool:
        return self._internal_set().__contains__(item)

    def __len__(self) -> int:
        return self._internal_set().__len__()

    def __repr__(self) -> str:
        return '{' + ', '.join(str(item) for item in self) + '}'

    def __str__(self) -> str:
        return self.__repr__()
