#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
import os
from subprocess import getstatusoutput

from utils.types import PathLike


def check_pkg_config(path: PathLike, package_name: str, version: str) -> bool:
    cmd = "pkg-config --modversion {0}/lib/pkgconfig/{1}.pc".format(path, package_name)
    return getstatusoutput(cmd) == (0, version)
