from itertools import repeat
from typing import TypeVar, Tuple, cast

T = TypeVar('T')


def to_tuple_by_repetition_twice(element: T) -> Tuple[T, T]:
    return cast(Tuple[T, T], tuple(repeat(element, 2)))
