#  INTEL CONFIDENTIAL
#
#  Copyright (c) 2022 Intel Corporation
#  All Rights Reserved.
#
#  This software and the related documents are Intel copyrighted materials,
#  and your use of them is governed by the express license under which they
#  were provided to you ("License"). Unless the License provides otherwise,
#  you may not use, modify, copy, publish, distribute, disclose or transmit this
#  software or the related documents without Intel's prior written permission.
#
#  This software and the related documents are provided as is, with no express or
#  implied warranties, other than those that are expressly stated in the License.
from pathlib import Path
from typing import Dict

import yaml


def read_yaml_from_file(path: str) -> Dict[str, object]:
    with open(path, 'r') as file:
        return yaml.safe_load(file)


def safe_read_yaml(path_to_file: Path) -> Dict[str, object]:
    try:
        return yaml.safe_load(path_to_file.read_text()) or {}
    except FileNotFoundError:
        return {}
