echo "---- Installing Nix OS---------------"
bash <(curl -L https://nixos.org/nix/install) --daemon --yes
echo "---- Sourcing profile---------------"
source ~/.profile
sudo bash -c 'echo "source /nix/var/nix/profiles/default/etc/profile.d/nix-daemon.sh" >> /etc/environment'
echo "----Show PATH ---------------"
echo $PATH
echo "---Setting up Nix Environment----------------"
source /nix/var/nix/profiles/default/etc/profile.d/nix-daemon.sh
echo "----Show PATH after---------------"
echo $PATH
echo "---APT install packages----------------"
sudo apt-get update 
sudo apt-get install -y make jq default-jre
echo "------Adding bf-sde packages under $HOME/bf-sde-------------"
cd ~/bf-sde 
echo "-------------------"
nix-store --add-fixed sha256 bf-sde-9.13.4.tgz bf-reference-bsp-9.13.4.tgz
echo "---clond bf-sde nixpkgs from repo----------------"
cd ~; 
echo "-------------------"
git clone --branch master https://github.com/alexandergall/bf-sde-nixpkgs.git 
echo "-------------------"
cd ~/bf-sde-nixpkgs 
echo "---Install bf-sde Nixpkgs----------------"
make install
echo "----invoking sde-env-9.13.x for the first time---------------"
sde-env-9.13.4 --platform=model --pkgs=psmisc,unzip --python-modules=yappi,grpcio --command exit
echo "-------------------"
