#!/bin/bash

# This configuration file specifies various arguments used by the launch scripts.
# These variables are optional, but defining them in advance simplifies the use of the launch scripts.

# Image name and tag that contains the development tools
# Example: nvcr.io/doca/dpl_dev:<tag>
DEV_IMAGE=nvcr.io/nvidia/doca/dpl_dev:1.1.10-doca3.0.0-host

# IP where the DPL Runtime daemon (RTD) is running
# Example: 192.168.1.100
# DPL_RTD_IP=

# IP where the DPL RTD is running and the port for the P4 Runtime Server
# Example: ${DPL_RTD_IP}:9559
# P4RT_ADDRESS=${DPL_RTD_IP}:9559

# IP where the DPL RTD is running and the port for the DPL Admin
# Example: ${DPL_RTD_IP}:9600
# DPL_ADMIN_ADDRESS=${DPL_RTD_IP}:9600

# IP where the DPL RTD is running and the port for the DPL Nspect
# Example: ${DPL_RTD_IP}:9560
# DPL_NSPECT_ADDRESS=${DPL_RTD_IP}:9560
