#!/bin/bash
set -e

dev_image() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        -i | --image)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: ${arg} option must be followed by <docker image name> argument" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            DEV_IMAGE="${arg2}"
            ;;
        help)
            usage
            exit 0
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
    if [[ "${DEV_IMAGE}" == "" ]]; then
        echo "ERROR: invalid value for -i mandatory argument" >/dev/stderr
        usage
        exit 1
    fi
}

dpl_admin_address() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        -a)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: missing argument for -a <dpl_rtd_ip:port>" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            DPL_ADMIN_ADDRESS="${arg2}"
            ;;
        help)
            usage
            exit 0
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
}

dpl_nspect_address() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        -a)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: missing argument for -a <dpl_rtd_ip:port>" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            DPL_NSPECT_ADDRESS="${arg2}"
            ;;
        help)
            usage
            exit 0
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
}

p4rt_address() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        -a)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: missing argument for -a <dpl_rtd_ip:port>" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            P4RT_ADDRESS="${arg2}"
            ;;
        help)
            usage
            exit 0
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
}

apply_program_folder() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        -p | --program)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: missing argument for -p <program folder>" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            PROGRAM_FOLDER="$(realpath ${arg2})"
            ;;
        help)
            usage
            exit 0
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
}

apply_extra_mount_folders() {
    OPTIONS=()
    while [ $# -gt 0 ]; do
        arg="$1"
        shift
        case "$arg" in
        --mount)
            if [[ $# -eq 0 ]]; then
                echo "ERROR: ${arg} option must be followed by <path> argument" >/dev/stderr
                usage
                exit 1
            fi
            arg2="$1"
            shift
            mount_dirs+=("$(realpath ${arg2})")
            ;;
        *)
            OPTIONS+=("$arg")
            ;;
        esac
    done
}

dev_volumes() {
    IFS=" " read -r -a mount_dirs <<<"$(echo "$@" | sort -u)"
    mount_dirs+=("$(realpath ${PWD})")
    VOLUMES=()
    for mount_dir in "${mount_dirs[@]}"; do
        VOLUMES+=("-v" "${mount_dir}":"${mount_dir}")
    done
}

create_tmp_execution_script() {
    local VENV_PATH=$1; shift
    TMPFILE=$(mktemp)
    cat<<EOF >> ${TMPFILE}
#!/bin/bash
source ${VENV_PATH}/activate
$@
EOF
    chmod +x ${TMPFILE}
}

set_docker_user_and_groups() {
    DOCKER_USER_AND_GROUPS=("--user $(id -u):$(id -g)")
    for gid in $(id -G); do
        DOCKER_USER_AND_GROUPS+=("--group-add=${gid}")
    done
}
