# TFM - Deployment and evaluation of network systems programmed using P4.
Welcome to the GitHub repository for my Master's thesis project! This repository contains all the code and documents used.

The project is designed for deploying and testing custom P4 programs using FABRIC nodes with the simple_switch architecture, a software switch from the BMv2 project. The project defines three primary topologies: L2 Ethernet forwarding, L3 IPv4 forwarding, and L3 IPv6 forwarding. Additionally, it includes an exercise implementing Inband Network Telemetry (INT) on the L3 IPv4 forwarding topology. In the Inband Network Telemetry (INT) exercise within the project, there’s an example that demonstrates not only the implementation of INT on the L3 IPv4 forwarding topology but also how to extract data from these topologies and represent them visually. This provides a practical guide for handling and analyzing network data, offering insights into protocol behavior and network performance across various test scenarios. 

## Repository Structure - Topologies

- **L2:** L2 Ethernet forwarding.
- **L3-ipv4:** L3 IPv4 forwarding.
- **INT-ipv4:** L3 IPv4 INT (In-band Network Telemetry) forwarding.
- **L3-ipv6:** L3 IPv6 forwarding.

## Quick Start

1. Clone the repository:
   ```
   git clone https://github.com/LauSeVe/TFM.git
   ```
2. Run the Jupyter Notebooks

## Contact

For any inquiries, feel free to reach out via email at lauraserranovelazquez@gmail.com or open an issue on this repository.
