/*----------------- MAIN ----------------*/
#include <doca_model.p4>
#include <doca_headers.p4>
#include <doca_externs.p4>
#include <doca_parser.p4>

/*----------------- CONTROL ----------------*/
control static_l2_forwarding(
    inout nv_headers_t headers,
    in nv_standard_metadata_t std_meta,
    inout nv_empty_metadata_t user_meta,
    inout nv_empty_metadata_t pkt_out_meta
) {
    action drop() {
        nv_drop();
    }
 
    action forward(bit<32> port) {
        bit<32> tmp_ip = headers.ipv4.src_addr;
        headers.ipv4.src_addr = headers.ipv4.dst_addr;
        headers.ipv4.dst_addr = tmp_ip; 
        nv_send_to_port(port);
    }

    table forward_table {
        key = {
            headers.ethernet.dst_addr : exact;
        }

        actions = {
            drop;
            forward;
            NoAction;
        }

        default_action = drop;

        const entries = {
            (48w0x001111111111) : forward(1);
            (48w0x002222222222) : forward(0);
            (48w0x00dddddddddd) : drop();
            (48w0x00aaaaaaaaaa) : NoAction();
            (48w0x00bbbbbbbbbb) : NoAction();
        }
    }

    apply {
        forward_table.apply();
    }
}

/*----------------- PIPELINE ----------------*/
NvDocaPipeline(
    nv_fixed_parser(),
    static_l2_forwarding()
) main;

