#!/bin/bash
set -e  # Exit immediately if a command fails

echo "=== Step 1: Downloading NGC CLI for ARM64 ==="
wget --content-disposition \
  https://api.ngc.nvidia.com/v2/resources/nvidia/ngc-apps/ngc_cli/versions/3.58.0/files/ngccli_arm64.zip \
  -O ngccli_arm64.zip

echo "=== Step 2: Unzipping NGC CLI ==="
unzip -o ngccli_arm64.zip

echo "=== Step 3: Downloading DPL Runtime Service ==="
./ngc-cli/ngc registry resource download-version "nvidia/doca/dpl_rt_service:1.1.0-doca3.0.0"

echo "=== Installation Complete ==="
