#!/usr/bin/env python3

from scapy.all import Ether, IP, UDP, sendp, Raw
import time

# Interface used on H2
iface = "enp7s0"

# Correct MAC addresses
src_mac = "0a:9b:37:1b:52:de"
dst_mac_rule_1 = "00:11:11:11:11:11"
dst_mac_rule_2 = "00:22:22:22:22:22"
dst_mac_rule_3 = "00:dd:dd:dd:dd:dd"

# IP addresses
src_ip = "192.168.0.2"
dst_ip = "192.168.0.1"

# Construct the packet: Ethernet + IP + payload
eth_rule_1 = Ether(src=src_mac, dst=dst_mac_rule_1, type=0x0800)
eth_rule_2 = Ether(src=src_mac, dst=dst_mac_rule_2, type=0x0800)
eth_rule_3 = Ether(src=src_mac, dst=dst_mac_rule_3, type=0x0800)
ip = IP(src=src_ip, dst=dst_ip, proto=17, ttl=64)
udp = UDP(sport=12345, dport=80)

# Send 5 packets with rule 1 mac address
for i in range(5):
    packet = eth_rule_1 / ip / udp / Raw(load="Hello packet")
    sendp(packet, iface=iface, verbose=False)
    # print(f"Send packet {i+1} from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_1}) via {iface}")
    time.sleep(0.2)

print(f"\n--- Sent 5 packets from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_1}) ---")

# Send 10 packets with rule 2 mac address
for i in range(10):
    packet = eth_rule_2 / ip / udp / Raw(load="Hello packet")
    sendp(packet, iface=iface, verbose=False)
    # print(f"Send packet {i+1} from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_2}) via {iface}")
    time.sleep(0.2)

print(f"\n--- Sent 10 packets from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_2}) ---")

# Send 15 packets with rule 3 mac address
for i in range(15):
    packet = eth_rule_3 / ip / udp / Raw(load="Hello packet")
    sendp(packet, iface=iface, verbose=False)
    # print(f"Send packet {i+1} from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_3}) via {iface}")
    time.sleep(0.2)

print(f"\n--- Sent 15 packets from {src_ip} ({src_mac}) to {dst_ip} ({dst_mac_rule_3}) ---")