import re

def get_pcie_id(devname: str):
    """
    Gets the PCIe ID from the device name, under
    the assumption that the relation is as:
    - enp7s0 => 0000:07:00.0
    - eth1 => 0000:01:00.0
    """
    match = re.search(r'(\d+)', devname)
    if match:
        return f"0000:{int(match.group(1))}:00.0"
    return None

def analyze_pcaps(pcapA, pcaps, output_str, host):
    command = f"python3 utilities/pcap_diff.py {pcapA} working/{output_str} -i {pcaps[0]}"
    for i in range(1, len(pcaps)):
        command += f" pcaps[i]"
    print("Analyzing pcaps...", end="")
    host.execute(command, quiet=True)
    print("Done")
    command = f"python3 utilities/grapher.py working/{output_str}_1.csv"
    for i in range(1, len(pcaps)):
        command += f" {output_str}_{i+1}.csv"
    host.execute(command, quiet=True)
    
