'''client server packet generator'''
import sys
import json
import logging
from .generator_generic import GeneratorGeneric
from .generator_generic_socproc import GeneratorGeneric1
from .generator_generic_new import GeneratorGeneric1a
from .generatortype1 import GeneratorType1
from .generatortype2 import GeneratorType2
from .generatortype3 import GeneratorType3
from .generatortype4 import GeneratorType4

logger = logging.getLogger(__name__)

def byteify(input): 
    if isinstance(input, dict):     
        return dict([(byteify(key), byteify(value)) for key,
         value in list(input.items())])
    elif isinstance(input, list):   
        return [byteify(element) for element in input]   
    elif isinstance(input, str):
        return input.encode('utf-8')
    else:
        return input    

class Genpackets():
    '''Genpackets uses traffic model files and a user sessions file to
    generate packets on a device, using the device operating system
    networking stack.'''

    def __init__(self, allappmodels, allusessions, client, outdir, modeltype='Type4'):
        '''
        Parameters
        ----------
        allappmodels : str
            traffic model file to use in generating traffic
        allusersessions : str
            json file containing details of all user sessions for which
            traffic should be generated, and their start times.
        client : bool
            if true traffic should be generated in client mode on the 
            device. Otherwise, generate in server mode.
        outdir : str
            output directory to save log files
        modeltype : str
            the modeling method used to create the application model
            file, which will also be used to generate traffic. options
            are from the set ('Type1','Type2', 'Type3', 'Type4')
        '''
        self.allappmodels = allappmodels
        self.allusessions = allusessions
        # self.allappmodels = json.load(open(allappmodels)) if isinstance(allappmodels, str) else allappmodels
        # self.allusessions = json.load(open(allusessions)) if isinstance(allusessions, str) else allusessions
        # if sys.version_info[0] < 3:
        #     self.allappmodels = byteify(self.allappmodels)
        #     self.allusessions = byteify(self.allusessions)

        # self.allusessions.sort(key=lambda v: v['start'])
        self.client = client
        self.outdir = outdir
        self.modeltype = modeltype.capitalize()

    def generate(self):
        '''begin the packet generation process'''


        if isinstance(self.allappmodels, str):
            allappmodelsisfilename = True 
            allappmodelfile = open(self.allappmodels)
            mallappmodels = json.load(allappmodelfile) 
        else:
            allappmodelsisfilename = False 
            allappmodelfile = None
            mallappmodels = self.allappmodels

        if isinstance(self.allusessions, str):
            allusessionsisfilename = True 
            allusessionsfile = open(self.allusessions)
            mallusessions = json.load(allusessionsfile)  
        else:
            allusessionsisfilename = False 
            allusessionsfile = None
            mallusessions = self.allusessions

        if sys.version_info[0] < 3:
            mallappmodels = byteify(mallappmodels)
            mallusessions = byteify(mallusessions)

        mallusessions.sort(key=lambda v: v['start'])

        if self.modeltype == 'Type1':
            gen = GeneratorType1(mallappmodels, mallusessions,
                        self.client, self.outdir)
            gen.generate()
        elif self.modeltype == 'Type2':
            gen = GeneratorType2(mallappmodels, mallusessions,
                        self.client, self.outdir)
            gen.generate()
        elif self.modeltype == 'Type3':
            gen = GeneratorType3(mallappmodels, mallusessions,
                        self.client, self.outdir)
            gen.generate()
        elif self.modeltype == 'Type4':
            gen = GeneratorType4(mallappmodels, mallusessions,
                        self.client, self.outdir)
            gen.generate()
        else:
            raise ValueError('invalid model type selected')

        if allappmodelsisfilename:
            allappmodelfile.close()
            
        if allusessionsisfilename:
            allusessionsfile.close()
