import sys
import random
import logging
import pickle
import numpy as np
import scipy.stats as st
from scipy.interpolate import CubicSpline, interp1d

logger = logging.getLogger(__name__)

class ModelPredictor():
    def __init__(self):
        self.logger = logging.getLogger('genpackets.model.ModelPredictor')

    def predictVal(self, model_param, model_type='empiricaloutliers', args_list=None, minimize=False):

        if model_param == None or len(model_param) == 0:
            a = 0
        elif model_param['mtype'] == 'nodata':
            a = model_param['nodata']
        elif model_param['mtype'] == 'ecdf':
            a = random.choice(model_param['ecdf'])
        elif model_param['mtype'] == 'ecdf':
            a = random.choice(model_param['ecdf']) 
        else:
            mtype = model_param['mtype']
            model_class = getattr(sys.modules[__name__],mtype.capitalize())
            a = model_class().predictVal(model_param, args_list, minimize) 
        a = a if a else 0
        return  a

class Empiricaloutliers():
    def __init__(self):
        pass

    def predictVal(self, model_param, args_list=None, minimize=False):
        #return self.predictVal_ecdf(model_param)
        #print 'in emperical outliers'
        poutl = random.uniform(0, 1)
        if poutl > model_param['empiricaloutliers']['non_outlier_prob']:
            return random.choice(model_param['empiricaloutliers']['outliers'])
        else:
            return self.predictVal_percentile(model_param, minimize)

    def predictVal_percentile(self, model_param, minimize=False):
        x = model_param['empiricaloutliers']['x']
        y = model_param['empiricaloutliers']['y']
        rand = random.choice(range(0,101))
        cs = interp1d(x, y, 'linear')
        val = cs(rand)
        if minimize:
            l = max([i for i in x if rand >=i])
            s = x.index(l)
            val = y[s]
        if 0>val:
            print (y)
            logger.debug('************* val is negative ************* %s, for rand = %s', str(val), str(rand))
        return val

    def predictVal_ecdf(self, model_param):
        x = model_param['empiricaloutliers']['x']
        y = model_param['empiricaloutliers']['y']
        rand = random.choice(x)
        cs = interp1d(x, y, 'linear')
        val = cs(rand)
        return val

class Empirical():
    def __init__(self):
        pass

    def predictVal(self, model_param, args_list=None, minimize=False):
        #return self.predictVal_ecdf(model_param)
        return self.predictVal_percentile(model_param, minimize)

    def predictVal_percentile(self, model_param, minimize=False):
        x = model_param['empirical']['x']
        y = model_param['empirical']['y']
        rand = random.choice(range(0,101))
        cs = interp1d(x, y, 'linear')
        val = cs(rand)
        if minimize:
            l = max([i for i in x if rand >=i])
            s = x.index(l)
            val = y[s]
        if 0>val:
            print (y)
            logger.debug('************* val is negative ************* %s, for rand = %s', str(val), str(rand))
        return val

    def predictVal_ecdf(self, model_param):
        x = model_param['empirical']['x']
        y = model_param['empirical']['y']
        rand = random.choice(x)
        cs = interp1d(x, y, 'linear')
        val = cs(rand)
        return val

class Stochastic(object):
    def __init__(self):
        pass
        self.dist_names = ['norm', 'pareto', 'weibull_min', 'weibull_max',
                           'expon', 'lognorm', 'laplace']

    def predictVal(self, model_param, args_list=None, minimize=False):
        dist = getattr(st, model_param['stochastic']['dist_name'])
        param = model_param['stochastic']['dist_params']
        val = -1
        while True:
            val = dist.rvs(*param[:-2], loc=param[-2], scale=param[-1])
            if val <= model_param['max']*2 and val >= model_param['min']/2:
                break
        #if isinstance(model_param['min'], int):
        return val

class Discrete(object):
    def __init__(self):
        pass

    def predictVal(self, model_param, args_list=None, minimize=False):
        param = model_param['discrete']['dist_values']
        idx = np.arange(len(param[0]))
        dist = st.rv_discrete(name='Discrete', values=(idx, param[1]))
        val = dist.rvs()
        val = param[0][val]
        return val
    
class Discretebin(object):
    def __init__(self):
        pass
    
    def predictVal(self, model_param, args_list=None, minimize=False):
        param = model_param['discretebin']['dist_values']
        idx = np.arange(len(param[0]))
        dist = st.rv_discrete(name='Discretebin', values=(idx, param[2]))
        val = dist.rvs()
        val = np.random.normal(param[0][val], param[1][val])
        if isinstance(model_param['discretebin']['min'], int):
            val = int(round(val))
        if val < model_param['discretebin']['min']: val = model_param['discretebin']['min']
        if val > model_param['discretebin']['max']: val = model_param['discretebin']['max']
        return val

class Regressor(object):
    def __init__(self):
        pass

    def predictVal(self, model_param, args_list=None, minimize=False):
        print((args_list, '\n\n', model_param['regressor']['x_features']))
        assert(len(args_list) == len(model_param['regressor']['x_features']))
               
        param = pickle.loads(model_param['regressor']['y_alg_pickle'])
        
        val = param.predict([args_list])
               
        if isinstance(model_param['regressor']['min'], int):
            val = int(round(val))
        if val < model_param['regressor']['min']: val = model_param['regressor']['min']
        if val > model_param['regressor']['max']: val = model_param['regressor']['max']
        return val
