# Copyright (c) 2024  Kent State University CAE-NetLab

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import json

def fast_get_interface_ip (interface):
  sout,serr = interface.get_node().execute("ip -j addr show scope global",
                                            read_timeout=1, quiet=True, retry=0)
  jout = json.loads(sout)
  intf_mac = interface.get_mac()

  for entry in jout:
    if entry["address"] == intf_mac:
      return entry["addr_info"][0]["local"]


