# Copyright (c) 2024  Kent State University CAE-NetLab

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import ipywidgets as widgets

from ..core.config import CFG, CFGSPEC

class ConfigManager():
  def __init__ (self, tabmgr):
    self._tabmgr = tabmgr

    self._w_topicselect = widgets.Select(options = sorted([x for x in CFGSPEC.keys()]), 
                                         layout = widgets.Layout(width="auto"))
    self._w_topicselect.observe(self._topicselect_observe, names=["value"])

    self._w_labelvbox = widgets.VBox([])
    self._w_widgetvbox = widgets.VBox([])

    self._w_itemhbox = widgets.HBox([self._w_labelvbox, self._w_widgetvbox])
    self._w_hbox = widgets.HBox([self._w_topicselect, self._w_itemhbox])

    self._setTopic(self._w_topicselect.value)

  def _topicselect_observe (self, change):
    self._setTopic(change["new"])

  def _setTopic (self, topic):
    items = CFGSPEC[topic]
    
    labels = []
    controls = []
    for citem in items:
      labels.append(widgets.Label(value=citem.uiname))
      controls.append(citem.datatype.getUIElement(CFG[citem.key]))

    self._w_labelvbox.children = labels
    self._w_widgetvbox.children = controls

  def display (self):
    return self._w_hbox

