# Copyright (c) 2024  Kent State University CAE-NetLab

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

from IPython.core.magic import Magics, magics_class, line_magic

from . import traftabmgr

from ..core import logging

@magics_class
class TrafGenMagics(Magics):
  def __init__ (self, shell):
    super().__init__(shell)
    shell.push({"_tgm" : self})
    self.ttm = None

  @line_magic
  def trafgen (self, line):
    if not self.ttm:
      self.ttm = traftabmgr.TrafTabManager()
    return self.ttm.display()
