# Copyright (c) 2018-2022  University of Houston Networking Lab

from distutils.core import setup
import setuptools

docs_require = ["sphinx",
                "sphinx_rtd_theme",
                "autodoc"]

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(name="ipktgen",
      version="0.0.0.1",
      description="intelligent (model) based packet generation tools and associated software",
      long_description=long_description,
      long_description_content_type="text/markdown",
      url="http://docs.uh-netlab.org/projects/ipktgen",
      author="UH-Netlab, Oluwamayowa Adeleke",
      author_email="oluwamayowa.adeleke@gmail.com",
      packages=setuptools.find_packages(),
      scripts=["bin/ipktgen"],
      include_package_data=True,
      zip_safe=False,
      install_requires=[
          "netifaces",
          "dpkt",
          "numpy",
          "pandas",
          "scipy"
          ],
      extras_require = { "docs" : docs_require },
      classifiers=[ 
        "Development Status :: 3 - Alpha",
        "Environment :: Console",
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: Mozilla Public License 2.0 (MPL 2.0)",
        ],
      python_requires=">=3.6",
      )
