# Copyright (c) 2024  Kent State University CAE-NetLab

# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import ipywidgets as widgets

class EndlessProgress():
  def __init__ (self, steps = 10):
    self._max = steps
    self._cur = 0
    self._bar = widgets.IntProgress(min = 0, max = self._max, bar_style="info", orientation = "horizontal")
    
  def advance (self, *args, **kwargs):
    self._cur += 1
    if self._cur > self._max:
        self._cur = 0
    self._bar.value = self._cur
    
  def done (self, *args, **kwargs):
    self._bar.value = self._max
    self._bar.bar_style = "success"

  def reset (self, *args, **kwargs):
    self._bar.value = 0
    self._bar.bar_style = "info"
    
  def display (self):
    return self._bar
