/*******************************************************************************
 * BAREFOOT NETWORKS CONFIDENTIAL & PROPRIETARY
 *
 * Copyright (c) 2019-present Barefoot Networks, Inc.
 *
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Barefoot Networks, Inc. and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Barefoot Networks, Inc.
 * and its suppliers and may be covered by U.S. and Foreign Patents, patents in
 * process, and are protected by trade secret or copyright law.  Dissemination of
 * this information or reproduction of this material is strictly forbidden unless
 * prior written permission is obtained from Barefoot Networks, Inc.
 *
 * No warranty, explicit or implicit is provided, unless granted under a written
 * agreement with Barefoot Networks, Inc.
 *
 ******************************************************************************/

#ifndef _HEADERS_
#define _HEADERS_

typedef bit<48> mac_addr_t;
typedef bit<32> ipv4_addr_t;
typedef bit<128> ipv6_addr_t;
typedef bit<12> vlan_id_t;

typedef bit<16> ether_type_t;
const ether_type_t ETHERTYPE_IPV4 = 16w0x0800;
const ether_type_t ETHERTYPE_ARP = 16w0x0806;
const ether_type_t ETHERTYPE_IPV6 = 16w0x86dd;
const ether_type_t ETHERTYPE_VLAN = 16w0x8100;
const ether_type_t ETHERTYPE_QINQ = 16w0x88A8;

typedef bit<8> ip_protocol_t;
const ip_protocol_t IP_PROTOCOLS_ICMP = 1;
const ip_protocol_t IP_PROTOCOLS_TCP = 6;
const ip_protocol_t IP_PROTOCOLS_UDP = 17;

header ethernet_h {
    mac_addr_t dst_addr;
    mac_addr_t src_addr;
    bit<16> ether_type;
}

header vlan_tag_h {
    bit<3> pcp;
    bit<1> cfi;
    vlan_id_t vid;
    bit<16> ether_type;
}

header mpls_h {
    bit<20> label;
    bit<3> exp;
    bit<1> bos;
    bit<8> ttl;
}

header ipv4_h {
    bit<4> version;
    bit<4> ihl;
    bit<8> diffserv;
    bit<16> total_len;
    bit<16> identification;
    bit<3> flags;
    bit<13> frag_offset;
    bit<8> ttl;
    bit<8> protocol;
    bit<16> hdr_checksum;
    ipv4_addr_t src_addr;
    ipv4_addr_t dst_addr;
}

header ipv6_h {
    bit<4> version;
    bit<8> traffic_class;
    bit<20> flow_label;
    bit<16> payload_len;
    bit<8> next_hdr;
    bit<8> hop_limit;
    ipv6_addr_t src_addr;
    ipv6_addr_t dst_addr;
}

header tcp_h {
    bit<16> src_port;
    bit<16> dst_port;
    bit<32> seq_no;
    bit<32> ack_no;
    bit<4> data_offset;
    bit<4> res;
    bit<8> flags;
    bit<16> window;
    bit<16> checksum;
    bit<16> urgent_ptr;
}

header udp_h {
    bit<16> src_port;
    bit<16> dst_port;
    bit<16> hdr_length;
    bit<16> checksum;
}

header icmp_h {
    bit<8> type_;
    bit<8> code;
    bit<16> hdr_checksum;
}

header arp_h {
    bit<16> hw_type;
    bit<16> proto_type;
    bit<8> hw_addr_len;
    bit<8> proto_addr_len;
    bit<16> opcode;
}

header ipv6_srh_h {
    bit<8> next_hdr;
    bit<8> hdr_ext_len;
    bit<8> routing_type;
    bit<8> seg_left;
    bit<8> last_entry;
    bit<8> flags;
    bit<16> tag;
}

header gre_h {
    bit<1> C;
    bit<1> R;
    bit<1> K;
    bit<1> S;
    bit<1> s;
    bit<3> recurse;
    bit<5> flags;
    bit<3> version;
    bit<16> proto;
}

header telemetry_report_h {
    bit<4> f_version;
    bit<4> f_length;
    bit<3> f_next_proto;
    bit<6> f_rep_md_bits;
    bit<6> f_rsvd;
    bit<1> f_drop;
    bit<1> f_queue;
    bit<1> f_flow;
    bit<6> f_hw_id;
    bit<32> switch_id;
    bit<32> f_seq_num;
    bit<32> f_ingress_ts;
}

header int_shim_h {
    bit<8> shim_type;
    bit<8> shim_rsvd1;
    bit<8> shim_len;
    bit<8> shim_rsvd2;
}

header int_metadata_h {
    bit<4> int_version;
    bit<2> int_replication;
    bit<1> int_copy;
    bit<1> int_hop_exceeded;
    bit<1> int_mtu_exceeded;
    bit<10> int_rsvd;
    bit<5> int_hop_ml;
    bit<8> int_remaining_hop_cnt;
    bit<1> int_bit_0_switch_id;
    bit<1> int_bit_1_ingress_egress_id;
    bit<1> int_bit_2_hop_latency;
    bit<1> int_bit_3_queue_id_occupancy;
    bit<1> int_bit_4_ingress_ts;
    bit<1> int_bit_5_egress_ts;
    bit<1> int_bit_6_queue_id_congestion;
    bit<1> int_bit_7_egress_tx_utilization;
    bit<8> int_rsvd_instructions;
    bit<16> int_rsvd_2;
}

header int_stack_h {
    bit<32> int_switch_id;
    bit<16> ingress_port_id;
    bit<16> egress_port_id;
    bit<32> hop_latency;
    bit<8> hop_queue_id;
    bit<24> queue_occupancy;
    bit<32> ingress_timestamp;
    bit<32> egress_timestamp;
}

struct header_t {
    ethernet_h outer_ethernet;
    vlan_tag_h outer_vlan1;
    vlan_tag_h outer_vlan2;
    ipv4_h outer_ipv4;
    tcp_h outer_tcp;
    udp_h outer_udp;
    telemetry_report_h telemetry_report;
    ethernet_h inner_ethernet;
    vlan_tag_h inner_vlan1;
    vlan_tag_h inner_vlan2;
    ipv4_h inner_ipv4;
    tcp_h inner_tcp;
    udp_h inner_udp;
    int_shim_h int_shim;
    int_metadata_h int_metadata;
    int_stack_h int_stack;
}

struct empty_header_t {}

struct empty_metadata_t {}

#endif /* _HEADERS_ */