# GraphBLAS Installation on FABRIC
This project describes the first FABRIC deployment of GraphBLAS—a powerful linear algebra-based framework for network traffic analysis. FABRIC is an international network testbed that is used for teaching and research in networking.

This work has two goals to provide a foundation for further research on network security: (1) deploying an advanced network monitoring technique on FABRIC, and (2) making this deployment shareable with other FABRIC users.

These goals are achieved by creating FABRIC experiments that build and deploy GraphBLAS to process network traffic on FABRIC. These experiments are described as executable Jupyter notebooks that are shareable with other researchers.

These experiments also include the replaying of network workloads (from pcap files), which we use to test and evaluate the deployment.

## Repository Structure
- accolade: contains dependencies used to build GraphBLAS.
- fabric: contains Jupyter notebooks and scripts used.
- pcap files: contains publicly available pcap files used.

## Quick Start

1. Clone the repository:
   ```
   git clone https://gitlab.com/d-r-r/graphblas/gbf.git
   ```
2. Run the Jupyter Notebooks on the FABRIC Folder
 - gbFabric.ipynb: Install GraphBLAS on one node on FABRIC.
 - Iperftests.ipynb: Install GraphBLAS on one node, capture traffic among 5 nodes and run graphBLAS to analyse the traffic patterns. 

## Contact

For any inquiries, feel free to reach out via email at vramdhony@hawk.iit.edu or open an issue on this repository.
